//+------------------------------------------------------------------+
//|                               Top 8 Trenders all brokers v2.mq4 |
//|                                                    Edward Munroe |
//|                                                       Hugh Briss |
//+------------------------------------------------------------------+
#property copyright "Edward Munroe"

#property indicator_chart_window

extern int hgap = 100;
extern int vgap = 20;
extern int x = 0;
extern int y = 20;
extern int fontsize = 8;
extern int tf1 = 1;
extern int tf2 = 5;
extern int tf1malength = 100;
extern int tf1matype = 3;
extern int tf1maprice = 0;
extern int tf1lookback = 15;
extern int tf2malength = 100;
extern int tf2matype = 3;
extern int tf2maprice = 0;
extern int tf2lookback = 12;
extern bool useatr = false;
extern string prefix = "";
extern string suffix = "";

string pairss[27];
double currsma1[27], prevsma1[27], currsma2[27], prevsma2[27];
double smadifftf1[27], smadiffpercenttf1[27], smadifftf2[27], smadiffpercenttf2[27];
color trendslopecoltf1[27], trendslopecoltf2[27];
double smadiffpercentarraytf1[27][2], smadiffpercentarraytf2[27][2];
string tf1s, tf2s;

int start() 
{
  // Pause and refresh
  Sleep(2000);
  
  // Define strings
  
  pairss[0] = prefix + "EURUSD" + suffix; pairss[1] = prefix + "EURGBP" + suffix; pairss[2] = prefix + "EURJPY" + suffix; 
  pairss[3] = prefix + "EURCAD" + suffix; pairss[4] = prefix + "EURAUD" + suffix; pairss[5] = prefix + "EURNZD" + suffix; 
  pairss[6] = prefix + "GBPUSD" + suffix; pairss[7] = prefix + "GBPCHF" + suffix; pairss[8] = prefix + "GBPJPY" + suffix; 
  pairss[9] = prefix + "GBPCAD" + suffix; pairss[10] = prefix + "GBPAUD" + suffix; pairss[11] = prefix + "GBPNZD" + suffix; 
  pairss[12] = prefix + "AUDUSD" + suffix; pairss[13] = prefix + "AUDCHF" + suffix; pairss[14] = prefix + "AUDJPY" + suffix; 
  pairss[15] = prefix + "AUDCAD" + suffix; pairss[16] = prefix + "AUDNZD" + suffix; pairss[17] = prefix + "NZDUSD" + suffix; 
  pairss[18] = prefix + "NZDCHF" + suffix; pairss[19] = prefix + "NZDJPY" + suffix; pairss[20] = prefix + "NZDCAD" + suffix;
  pairss[21] = prefix + "USDCHF" + suffix; pairss[22] = prefix + "USDJPY" + suffix; pairss[23] = prefix + "USDCAD" + suffix;
  pairss[24] = prefix + "CADCHF" + suffix; pairss[25] = prefix + "CADJPY" + suffix; pairss[26] = prefix + "CHFJPY" + suffix;
  
  if(tf1 == 1) tf1s = "1 Min"; if(tf1 == 5) tf1s = "5 Min"; if(tf1 == 15) tf1s = "15 Min"; if(tf1 == 30) tf1s = "30 Min";
  if(tf1 == 60) tf1s = "Hourly"; if(tf1 == 240) tf1s = "4 Hour"; if(tf1 == 1440) tf1s = "Daily"; if(tf1 == PERIOD_W1) tf1s = "Weekly";
  
  if(tf2 == 5) tf2s = "5 Min"; if(tf2 == 15) tf2s = "15 Min"; if(tf2 == 30) tf2s = "30 Min"; if(tf2 == 60) tf2s = "Hourly"; 
  if(tf2 == 240) tf2s = "4 Hour"; if(tf2 == 1440) tf2s = "Daily"; if(tf2 == PERIOD_W1) tf2s = "Weekly"; if(tf2 == PERIOD_MN1) tf2s = "Monthly";
  
 // Calculate indicators
  
  int counter1 = 0;
  while(counter1 < 27)
  {
  currsma1[counter1] = iMA(pairss[counter1],tf1,tf1malength,0,tf1matype,tf1maprice,1);
  prevsma1[counter1] = iMA(pairss[counter1],tf1,tf1malength,0,tf1matype,tf1maprice,tf1lookback);
  currsma2[counter1] = iMA(pairss[counter1],tf2,tf2malength,0,tf2matype,tf2maprice,1);
  prevsma2[counter1] = iMA(pairss[counter1],tf2,tf2malength,0,tf2matype,tf2maprice,tf2lookback);
  
  // Calculate trend percent
  if(currsma1[counter1] >= prevsma1[counter1]) smadifftf1[counter1] = currsma1[counter1] - prevsma1[counter1];
  if(currsma1[counter1] < prevsma1[counter1]) smadifftf1[counter1] = prevsma1[counter1] - currsma1[counter1];
  if(currsma2[counter1] >= prevsma2[counter1]) smadifftf2[counter1] = currsma2[counter1] - prevsma2[counter1];
  if(currsma2[counter1] < prevsma2[counter1]) smadifftf2[counter1] = prevsma2[counter1] - currsma2[counter1];
  
  if(useatr == false)
  {
  int pipMult = 1000000;
  if(StringFind(pairss[counter1],"JPY",0) != -1) pipMult = 10000;
  
  smadiffpercenttf1[counter1] = (smadifftf1[counter1]/tf1lookback) * pipMult;
  smadiffpercenttf2[counter1] = (smadifftf2[counter1]/tf2lookback) * pipMult;
  }
  else if(useatr == true)
  {
  double tf1atr = iATR(pairss[counter1],tf1,20,1);
  double tf2atr = iATR(pairss[counter1],tf2,20,1);
  
  smadiffpercenttf1[counter1] = (smadifftf1[counter1]/tf1atr) * 100;
  smadiffpercenttf2[counter1] = (smadifftf2[counter1]/tf2atr) * 100;
  }
  
  trendslopecoltf1[counter1] = Red;
  if(currsma1[counter1] > prevsma1[counter1]) trendslopecoltf1[counter1] = Green;
  if(currsma1[counter1] < prevsma1[counter1]) trendslopecoltf1[counter1] = Blue;
  trendslopecoltf2[counter1] = Red;
  if(currsma2[counter1] > prevsma2[counter1]) trendslopecoltf2[counter1] = Green;
  if(currsma2[counter1] < prevsma2[counter1]) trendslopecoltf2[counter1] = Blue;
  
  smadiffpercentarraytf1[counter1][0] = smadiffpercenttf1[counter1];
  smadiffpercentarraytf1[counter1][1] = counter1;
  smadiffpercentarraytf2[counter1][0] = smadiffpercenttf2[counter1];
  smadiffpercentarraytf2[counter1][1] = counter1;
    
  counter1++;
  }
  
  // Sort diff array and display strongest 8 pairs
  ArraySort(smadiffpercentarraytf1,WHOLE_ARRAY,0,MODE_DESCEND);
  ArraySort(smadiffpercentarraytf2,WHOLE_ARRAY,0,MODE_DESCEND);
  
  Display("top8"+tf1, x,y);
  ObjectSetText("top8"+tf1,"Top 8 - " + tf1s,8,"Verdana",Black);
  Display("top8under"+tf1,x,y);
  ObjectSetText("top8under"+tf1,"_____",8,"Verdana",Black);
  
  Display("top8"+tf2, x+hgap,y);
  ObjectSetText("top8"+tf2,"Top 8 - " + tf2s,8,"Verdana",Black);
  Display("top8under"+tf2,x+hgap,y);
  ObjectSetText("top8under"+tf2,"_____",8,"Verdana",Black);
  
  
  int counterm = 0;
  while(counterm < 8)
  {
  int pair1 = smadiffpercentarraytf1[counterm][1];
  int pair2 = smadiffpercentarraytf2[counterm][1];
      
  Display("strongesttrends" + counterm + tf1, x,y + ((vgap * counterm)-20) + (vgap*2)); 
  ObjectSetText("strongesttrends" + counterm + tf1,pairss[pair1] + " / " + DoubleToStr(smadiffpercenttf1[pair1],0),fontsize,"Verdana",trendslopecoltf1[pair1]);
  Display("strongesttrends" + counterm + tf2, x+hgap,y + ((vgap * counterm)-20) + (vgap*2)); 
  ObjectSetText("strongesttrends" + counterm + tf2,pairss[pair2] + " / " + DoubleToStr(smadiffpercenttf2[pair2],0),fontsize,"Verdana",trendslopecoltf2[pair2]);
  
  counterm++;
  }
       
return(0);
  }
  
void Display(string name, int x2, int y2)
   {
   ObjectCreate(name, OBJ_LABEL, 0, 0, 0);
   ObjectSet(name, OBJPROP_CORNER, 0);
   ObjectSet(name, OBJPROP_XDISTANCE, x2);
   ObjectSet(name, OBJPROP_YDISTANCE, y2);
   ObjectSet(name, OBJPROP_BACK, FALSE);
   } 

